// seed.js
const { sequelize, User } = require('./src/models');
const bcrypt = require('bcryptjs');
require('dotenv').config();

const createTeam = async () => {
    try {
        await sequelize.authenticate();
        // لا نستخدم force: true هنا لنحافظ على التقارير، فقط نضيف مستخدمين
        await sequelize.sync(); 

        const password = await bcrypt.hash('123456', 10);

        const users = [
            { username: 'inspector1', fullName: 'عبدالله الحويل (مفتش)', role: 'inspector' },
            { username: 'supervisor1', fullName: 'محمد المشرف', role: 'supervisor' },
            { username: 'manager1', fullName: 'سلطان المدير', role: 'env_manager' },
            { username: 'maint1', fullName: 'فريق الصيانة والتشغيل', role: 'maintenance' }
        ];

        console.log('🔄 جاري تهيئة المستخدمين...');

        for (const u of users) {
            const exists = await User.findOne({ where: { username: u.username } });
            if (!exists) {
                await User.create({ ...u, password });
                console.log(`✅ تم إنشاء: ${u.fullName} (${u.role})`);
            } else {
                console.log(`ℹ️ المستخدم ${u.username} موجود مسبقاً.`);
            }
        }
        
        console.log('\n🎉 اكتملت التهيئة! كلمة المرور للجميع: 123456');

    } catch (error) {
        console.error('❌ حدث خطأ:', error);
    } finally {
        process.exit();
    }
};

createTeam();