// src/config/db.config.js
const Sequelize = require('sequelize');
require('dotenv').config(); // لاستدعاء المتغيرات من ملف .env

// إنشاء مثيل الاتصال
const sequelize = new Sequelize(
    process.env.DB_NAME,     // اسم قاعدة البيانات
    process.env.DB_USER,     // اسم المستخدم (غالباً root)
    process.env.DB_PASSWORD, // كلمة المرور
    {
        host: process.env.DB_HOST,
        dialect: process.env.DB_DIALECT, // نوع قاعدة البيانات (mysql)
        logging: false, // (اختياري) لإخفاء سجلات SQL الطويلة في التيرمينال
        pool: {
            max: 5,
            min: 0,
            acquire: 30000,
            idle: 10000
        }
    }
);

module.exports = sequelize;