// src/controllers/workflowController.js
const { Report, User, Observation } = require('../models');

// تغيير حالة التقرير (اعتماد/رفض)
exports.processReport = async (req, res) => {
    try {
        const { reportId, action, note } = req.body; // action: 'approve' or 'reject'
        const currentUserRole = req.userData.role; // دور الشخص الذي ضغط الزر

        const report = await Report.findByPk(reportId);
        if (!report) return res.status(404).json({ message: "التقرير غير موجود" });

        let newStatus = report.status;

        // --- منطق سير العمل (State Machine) ---
        
        // 1. دور المشرف (Supervisor)
        if (currentUserRole === 'supervisor') {
            if (report.status === 'pending_supervisor') {
                if (action === 'approve') {
                    newStatus = 'pending_manager'; // إرسال للمدير
                } else if (action === 'reject') {
                    newStatus = 'rejected'; // إعادة للمفتش (أو draft)
                }
            } else {
                return res.status(403).json({ message: "هذا التقرير ليس بانتظار مراجعتك حالياً" });
            }
        }

        // 2. دور مدير البيئة (Manager)
        else if (currentUserRole === 'env_manager') {
            if (report.status === 'pending_manager') {
                if (action === 'approve') {
                    newStatus = 'approved_for_maintenance'; // إرسال للصيانة
                } else if (action === 'reject') {
                    newStatus = 'pending_supervisor'; // إعادة للمشرف
                }
            } else {
                return res.status(403).json({ message: "هذا التقرير ليس بانتظار اعتمادك" });
            }
        }

        // تحديث الحالة
        report.status = newStatus;
        await report.save();

        // (اختياري) يمكننا هنا إضافة سجل في جدول Log لحفظ من قام بالاعتماد والوقت
        
        res.json({ 
            message: `تم تنفيذ الإجراء: ${action}، الحالة الجديدة: ${newStatus}`,
            status: newStatus
        });

    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};

// إغلاق ملاحظة من قبل الصيانة
exports.closeObservation = async (req, res) => {
    try {
        const { observationId, actionTaken } = req.body;
        
        // التحقق من أن المستخدم من الصيانة
        if (req.userData.role !== 'maintenance') {
            return res.status(403).json({ message: "غير مصرح لك بهذا الإجراء" });
        }

        const observation = await Observation.findByPk(observationId);
        if (!observation) return res.status(404).json({ message: "الملاحظة غير موجودة" });

        // تحديث الملاحظة (يمكن إضافة صورة هنا أيضاً إذا استخدمنا الـ upload middleware)
        observation.status = 'تم التصحيح';
        observation.actionTaken = actionTaken;
        observation.isFixed = true;
        
        // ملاحظة: صورة "بعد الإصلاح" تحتاج لمعالجة خاصة مشابهة لرفع الصور السابق
        if (req.file) {
             observation.rectifiedImage = `/uploads/${req.file.filename}`;
        }

        await observation.save();

        res.json({ message: "تم إغلاق الملاحظة بنجاح" });

    } catch (error) {
        res.status(500).json({ message: error.message });
    }
};