// src/middleware/uploadMiddleware.js
const multer = require('multer');
const path = require('path');
const fs = require('fs');

// التأكد من وجود المجلد
const uploadDir = 'public/uploads';
if (!fs.existsSync(uploadDir)){
    fs.mkdirSync(uploadDir, { recursive: true });
}

// إعداد مكان التخزين والتسمية
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, uploadDir); // مكان الحفظ
    },
    filename: (req, file, cb) => {
        // تسمية الملف: report-رقم عشوائي-تاريخ.jpg
        const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1E9);
        cb(null, file.fieldname + '-' + uniqueSuffix + path.extname(file.originalname));
    }
});

// فلتر لقبول الصور فقط
const fileFilter = (req, file, cb) => {
    if (file.mimetype.startsWith('image/')) {
        cb(null, true);
    } else {
        cb(new Error('فقط ملفات الصور مسموح بها!'), false);
    }
};

const upload = multer({ 
    storage: storage,
    fileFilter: fileFilter,
    limits: { fileSize: 5 * 1024 * 1024 } // حد أقصى 5 ميجا للصورة
});

module.exports = upload;