// src/models/Observation.js
const { DataTypes } = require('sequelize');
const sequelize = require('../config/db.config');

const Observation = sequelize.define('observations', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    // 1. وصف الملاحظة / المخالفة
    description: {
        type: DataTypes.TEXT,
        allowNull: false
    },
    // 2. الإجراء المطلوب
    requiredAction: {
        type: DataTypes.TEXT,
        allowNull: false
    },
    // 3. صورة المخالفة (مسار الصورة)
    violationImage: {
        type: DataTypes.STRING, 
        allowNull: true // قد لا تتوفر صورة أحياناً
    },
    // 4. درجة الخطورة (تم تعديل الاسم والقيم)
    severity: {
        type: DataTypes.ENUM('منخفضة', 'متوسطة', 'عالية', 'حرجة'),
        defaultValue: 'متوسطة'
    },
    // 5. المدة التصحيحية
    correctionDuration: {
        type: DataTypes.STRING, // مثال: "أسبوع"، "24 ساعة"
        allowNull: false
    },
    // 6. صورة المخالفة بعد المعالجة (تُعبأ لاحقاً)
    rectifiedImage: {
        type: DataTypes.STRING,
        allowNull: true
    },
    // 7. حالة المخالفة
    status: {
        type: DataTypes.ENUM('مفتوحة', 'قيد المعالجة', 'تم التصحيح', 'مغلقة'),
        defaultValue: 'مفتوحة'
    },
    // 8. الإجراء المتخذ (يُعبأ لاحقاً من قبل الصيانة)
    actionTaken: {
        type: DataTypes.TEXT,
        allowNull: true
    }
});

module.exports = Observation;