// src/models/Report.js
const { DataTypes } = require('sequelize');
const sequelize = require('../config/db.config');

const Report = sequelize.define('reports', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    reportNumber: { // مثل F058
        type: DataTypes.STRING,
        allowNull: true
    },
    facilityName: { // المنشأة / الفرع
        type: DataTypes.STRING,
        allowNull: false
    },
    location: { // الموقع (مثلاً: منطقة الباحة)
        type: DataTypes.STRING,
        allowNull: true
    },
    visitDate: {
        type: DataTypes.DATEONLY,
        defaultValue: DataTypes.NOW
    },
    // هنا سنخزن إجابات الـ Checkbox (اجتياز/عدم اجتياز)
    // سيتم تخزينها كـ JSON مثل: { "waste_management": { "clean_site": "pass", "bins_ok": "fail" } }
    checklistData: { 
        type: DataTypes.JSON, 
        allowNull: true
    },
    status: {
        type: DataTypes.ENUM,
        values: [
            'draft',               
            'pending_supervisor',  
            'pending_manager',     
            'approved_for_maintenance', 
            'completed',           
            'rejected'             
        ],
        defaultValue: 'draft'
    }
});

module.exports = Report;