// src/models/index.js
const sequelize = require('../config/db.config');

// استيراد النماذج
const User = require('./User');
const Report = require('./Report');
const Observation = require('./Observation');

// --- تعريف العلاقات (Relationships) ---

// 1. المستخدم (المفتش) لديه تقارير كثيرة
User.hasMany(Report, { foreignKey: 'inspectorId', as: 'reports' });
Report.belongsTo(User, { foreignKey: 'inspectorId', as: 'inspector' });

// 2. التقرير يحتوي على ملاحظات كثيرة
Report.hasMany(Observation, { foreignKey: 'reportId', as: 'observations' });
Observation.belongsTo(Report, { foreignKey: 'reportId', as: 'report' });

// تصدير الكل
module.exports = {
    sequelize,
    User,
    Report,
    Observation
};