// seed.js
const db = require('./src/models'); // استدعاء الكائن الموحد
const { sequelize, User } = db;     // استخراج النماذج منه
const bcrypt = require('bcryptjs');
require('dotenv').config();

const createTeam = async () => {
    try {
        console.log('🔄 جاري الاتصال بقاعدة البيانات...');
        await sequelize.authenticate();
        
        // ⚠️ نستخدم force: true هنا لأننا قمنا بتغيير هيكلية الجداول (أضفنا أدوار وحالات جديدة)
        // هذا سيقوم بمسح البيانات القديمة وبناء الجداول من الصفر لضمان عدم حدوث أخطاء
        console.log('⚠️ جاري إعادة بناء الجداول وتحديث الهيكلة...');
        await sequelize.sync({ force: true }); 

        const password = await bcrypt.hash('123456', 10);

        const users = [
            { username: 'inspector1', fullName: 'عبدالله الحويل (مفتش)', role: 'inspector' },
            { username: 'section_mgr', fullName: 'فهد (مدير القسم)', role: 'section_manager' },
            { username: 'manager1', fullName: 'سلطان (مدير الإدارة)', role: 'env_manager' },
            { username: 'maint1', fullName: 'فريق الصيانة والتشغيل', role: 'maintenance' }
        ];

        console.log('👤 جاري إنشاء المستخدمين...');

        for (const u of users) {
            // بما أننا استخدمنا force: true فلا داعي للتحقق من الوجود، لكن لا بأس به
            await User.create({ ...u, password });
            console.log(`   + تم إنشاء: ${u.fullName} (${u.role})`);
        }
        
        console.log('\n🎉 اكتملت التهيئة بنجاح! كلمة المرور للجميع: 123456');

    } catch (error) {
        console.error('❌ حدث خطأ:', error);
    } finally {
        await sequelize.close();
        process.exit();
    }
};

createTeam();