// src/models/Observation.js
const { DataTypes } = require('sequelize');
const sequelize = require('../config/db.config'); // استدعاء الاتصال الصحيح

const Observation = sequelize.define('observations', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    description: {
        type: DataTypes.TEXT,
        allowNull: false
    },
    requiredAction: {
        type: DataTypes.TEXT,
        allowNull: false
    },
    violationImage: {
        type: DataTypes.STRING, 
        allowNull: true 
    },
    severity: {
        type: DataTypes.ENUM('منخفضة', 'متوسطة', 'عالية', 'حرجة'),
        defaultValue: 'متوسطة'
    },
    correctionDuration: {
        type: DataTypes.STRING, 
        allowNull: false
    },
    rectifiedImage: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.ENUM('مفتوحة', 'قيد المعالجة', 'تم التصحيح', 'مغلقة'),
        defaultValue: 'مفتوحة'
    },
    actionTaken: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    isFixed: {
        type: DataTypes.BOOLEAN,
        defaultValue: false
    }
});

module.exports = Observation;