// src/models/Report.js
const { DataTypes } = require('sequelize');
const sequelize = require('../config/db.config'); // استدعاء الاتصال الصحيح

const Report = sequelize.define('reports', {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true
    },
    reportNumber: {
        type: DataTypes.STRING,
        allowNull: true
    },
    facilityName: {
        type: DataTypes.STRING,
        allowNull: false
    },
    location: {
        type: DataTypes.STRING,
        allowNull: true
    },
    visitDate: {
        type: DataTypes.DATEONLY,
        defaultValue: DataTypes.NOW
    },
    checklistData: { 
        type: DataTypes.JSON, 
        allowNull: true
    },
    // تم تحديث الحالات لتطابق النظام الجديد
    status: {
        type: DataTypes.ENUM,
        values: [
            'new_request',              
            'pending_section_manager',  
            'pending_dept_manager',     
            'with_maintenance',         
            'maintenance_completed',    
            'completed',                
            'rejected'                  
        ],
        defaultValue: 'new_request'
    }
});

module.exports = Report;