const express = require('express');
const router = express.Router();

// استدعاء وحدة التحكم (التي تحتوي على logic)
const reportController = require('../controllers/reportController');

// استدعاء طبقة الحماية (للتحقق من تسجيل الدخول)
const checkAuth = require('../middleware/authMiddleware');

// استدعاء طبقة رفع الملفات (للصور)
const upload = require('../middleware/uploadMiddleware');

// --- تعريف المسارات (Endpoints) ---

// 1. إنشاء تقرير جديد (مع رفع صور)
// الترتيب: تحقق من الدخول -> اسمح برفع أي ملفات -> نفذ كود الإنشاء
router.post('/', 
    checkAuth, 
    upload.any(), // نستخدم .any() لأن أسماء حقول الصور ديناميكية (obs_image_0, obs_image_1...)
    reportController.createReport
);

// 2. جلب قائمة كل التقارير (للجدول في لوحة التحكم)
router.get('/', 
    checkAuth, 
    reportController.getAllReports
);

// 3. جلب تفاصيل تقرير محدد (لصفحة العرض والاعتماد)
// :id يعني رقم التقرير المتغير
router.get('/:id', 
    checkAuth, 
    reportController.getReportDetails
);

module.exports = router;